local TaskWithType = require("lua.util.tasks.TaskWithType")
local HighlightDeposit = TaskWithType("highlight_deposit")
HighlightDeposit.__index = HighlightDeposit

local Area = require("lua.util.Util").area_xywh

local function highlight_deposit(position, surface)
    if surface.count_entities_filtered({
        area = Area(position.x, position.y, 31, 31),
        type = "resource",
        limit = 1
    }) > 0 then
        local tiles_to_replace = {}
        for cx = 0, 31 do
            for cy = 0, 31 do
                if surface.count_entities_filtered({
                    area = Area(position.x + cx, position.y + cy, 1, 1),
                    type = "resource"
                }) > 0 then
                    tiles_to_replace[#tiles_to_replace + 1] = {
                        position = { x = position.x + cx, y = position.y + cy },
                        name = "dirt-7"
                    }
                end
            end
        end 
        if #tiles_to_replace > 1 then
            surface.set_tiles(tiles_to_replace, true)
        end
    end
end

function HighlightDeposit:executed()
    highlight_deposit(self.position, self.surface)
    return nil
end

function HighlightDeposit.new(deposit_position, surface)
    return HighlightDeposit({
        position = {
            x = deposit_position.x * 32,
            y = deposit_position.y * 32
        },
        surface = surface
    })
end

return HighlightDeposit
