local TaskWithType = require("lua.util.tasks.TaskWithType")
local ScanDeposits = TaskWithType("scan_deposits")
ScanDeposits.__index = ScanDeposits

local Area = require("lua.util.Util").area_xywh
local Random = require("lua.util.Random")
local BadlandsDeposits = require("lua.badlands.worldgen.decorations.resource.BadlandsDeposits")

local SCAN_RADIUS = 40
local floor = math.floor

local cached_resource = {}
local function try_notify_players(scan_event)
    if scan_event.surface.is_chunk_generated(scan_event.deposit.chunk_position) then
        local entity = scan_event.surface.find_entities_filtered({
            area = scan_event.deposit.area,
            name = scan_event.deposit.name,
            limit = 1
        })[1]
        if entity then
            cached_resource[scan_event.deposit.name] = cached_resource[scan_event.deposit.name] or {
                    name = entity.prototype.mineable_properties.products[1].name,
                    type = entity.prototype.mineable_properties.products[1].type,
                    localised_name = entity.prototype.localised_name
            }
            for _, player in pairs(scan_event.force.players) do
                player.add_custom_alert(
                    entity,
                    cached_resource[scan_event.deposit.name], {
                        "",
                        cached_resource[scan_event.deposit.name].localised_name,
                        " deposit has been discovered"
                    },
                    true
                )
            end
            scan_event.force.add_chart_tag(
                scan_event.surface, {
                    icon = { type = "virtual", name = "signal-green" },
                    position = {
                        x = scan_event.deposit.area.top_left.x + 30,
                        y = scan_event.deposit.area.top_left.y + 2,
                    },
                    text = cached_resource[scan_event.deposit.name].name
                }
            )
        end
        return true
    end
end

local function chart_deposit(deposit, scan_event)
    scan_event.deposit = {
        name = deposit.name,
        area = Area(deposit.x * 32, deposit.y * 32, 31, 31),
        chunk_position = { x = deposit.x, y = deposit.y }
    }
    scan_event.force.chart(scan_event.surface, scan_event.deposit.area)
end

local function border_region(center, radius)
    return floor((center / 32 + radius) / 32)
end

local function undiscovered_deposits(scan_event)
    local result = {}
    for x = border_region(scan_event.x, -SCAN_RADIUS), border_region(scan_event.x, SCAN_RADIUS) do
        for y = border_region(scan_event.y, -SCAN_RADIUS), border_region(scan_event.y, SCAN_RADIUS) do
            for _, deposit in pairs(BadlandsDeposits:in_region({ x = x, y = y })) do
                local uncharted_deposit = {
                    x = deposit.x + 32 * x,
                    y = deposit.y + 32 * y
                }
                if not scan_event.force.is_chunk_charted(scan_event.surface, uncharted_deposit) then
                    uncharted_deposit.name = deposit.name
                    result[#result+1] = uncharted_deposit
                end
            end
        end
    end
    return result
end

local function try_scan_deposit(scan_event)
    local deposits = undiscovered_deposits(scan_event)
    if #deposits > 0 then
        Random.seed(scan_event.x, scan_event.y, scan_event.tick)
        chart_deposit(deposits[Random.next_number(#deposits)], scan_event)
        return true
    end
end

function ScanDeposits:executed()
    self.active = #self.scan_events > 0 and true
    if self.active then
        local deposit_scanned = false
        if self.scan_events[#self.scan_events].deposit then
            -- stage 2 (wait for chunk generation and show notification)
            deposit_scanned = try_notify_players(self.scan_events[#self.scan_events])
        else
            -- stage 1 (look for undiscovered and request to generate)
            deposit_scanned = not try_scan_deposit(self.scan_events[#self.scan_events])
        end
        self.scan_events[#self.scan_events] = not deposit_scanned and self.scan_events[#self.scan_events] or nil
    end
    return self.active and self or nil
end

function ScanDeposits.new(scan_events)
    return ScanDeposits({ scan_events = scan_events })
end

return ScanDeposits
