local BadlandsData = require("lua.badlands.BadlandsData")
local ReadyForAnalysis = require("lua.util.worldgen.analysis.surfaces.ReadyForAnalysis")
local OregenAnalysis = require("lua.util.worldgen.analysis.OreGenReport")

return function (analysis_surface, precision)
    local cached_report = BadlandsData().oregen_analysis[analysis_surface.name]
    if not cached_report then
        analysis_surface = ReadyForAnalysis(analysis_surface)
        if analysis_surface then
            cached_report = OregenAnalysis(
                analysis_surface,
                precision
            )
            BadlandsData().oregen_analysis[analysis_surface.name] = cached_report
        end
    end
    return cached_report
end
