local AnalysisSurface = require("lua.util.worldgen.analysis.surfaces.AnalysisSurface")
local MapGen = require("lua.badlands.MapGen")

local function settings()
    local mgs = game.default_map_gen_settings
    -- With x2 frequency resources
    for resource, _ in pairs(
        game.get_filtered_entity_prototypes({
            { filter = "type", type = "resource" },
            { filter = "autoplace", mode = "and" }
        })
    ) do
        mgs.autoplace_controls[resource].frequency = 2 * mgs.autoplace_controls[resource].frequency
    end
    -- With default oregen
    mgs.property_expression_names = MapGen.property_expressions
    return mgs
end

return function ()
    return AnalysisSurface(
        "nauvis",
        2 ^ 5,
        settings()
    )
end