local AnalysisSurface = require("lua.util.worldgen.analysis.surfaces.AnalysisSurface")
local MapGen = require("lua.badlands.MapGen")

local function settings()
    local mgs = game.default_map_gen_settings
    -- With x0.5 size resources
    for resource, _ in pairs(
        game.get_filtered_entity_prototypes({
            { filter = "type", type = "resource" },
            { filter = "autoplace", mode = "and" }
        })
    ) do
        mgs.autoplace_controls[resource].size = 0.5 * mgs.autoplace_controls[resource].size
    end
    -- With default oregen
    mgs.property_expression_names = MapGen.property_expressions
    return mgs
end

return function ()
    return AnalysisSurface(
        "nauvis_starting_area",
        2 ^ 2,
        settings()
    )
end
