local SurfaceDecoration = require("lua.util.worldgen.decorations.SurfaceDecoration")
local NamedDecoration = require("lua.util.worldgen.decorations.NamedDecoration")

local badlands_surfaces = { "nauvis" }

local registered_decorations = {}

local function with_decoration(decoration)
    for _, surface in pairs(decoration.surfaces) do
        registered_decorations[surface] = registered_decorations[surface] or {}
        registered_decorations[surface][decoration.name] = decoration
    end
    return registered_decorations
end

with_decoration(
    SurfaceDecoration(
        badlands_surfaces,
        NamedDecoration(
            "resource_deposit",
            require("lua.badlands.worldgen.decorations.resource.ResourceDeposit")
        )
    )
)

with_decoration(
    SurfaceDecoration(
        badlands_surfaces,
        NamedDecoration(
            "biters_base",
            require("lua.badlands.worldgen.decorations.biters.BitersBase")
        )
    )
)

return registered_decorations
