local TaskQueue = require("lua.badlands.tasks.BadlandsQueue").queue
local DecorateChunksTask = require("lua.badlands.tasks.DecorateChunks").new

local BadlandsDecorations = require("lua.badlands.worldgen.decorations.BadlandsDecorations")
local TableWithDefault = require("lua.util.Util").table_with_default

local chunks_to_decorate = TableWithDefault(TableWithDefault)
local decorating_task = DecorateChunksTask(chunks_to_decorate)

local function activate_task()
    if not decorating_task.active then
        decorating_task.active = true
        TaskQueue():add_task(decorating_task)
    end
end

return function (chunk_position, surface)
    for _, decoration in pairs(BadlandsDecorations[surface.name] or {}) do
        table.insert(
            chunks_to_decorate[surface.name][decoration.name],
            chunk_position
        )
    end
    activate_task()
end
