local Regionated = require("lua.util.worldgen.Regionated")
local WithDistanceBonus = require("lua.util.worldgen.decorations.mods.DistanceBonus")
local RegionPositions = require("lua.util.worldgen.PositionsInRegions")
local Random = require("lua.util.Random")
local RANDOM_PRIME = 6047

local REGION_SIZE = 32

local max = math.max
local floor = math.floor
local function next_base()
    return {
        name = Random.next_number() < 0.7 and "worms" or "biters",
        amount = max(1, floor(10 + Random.next_number(0, 2))),
        area = max(1, floor(2 + Random.next_number(0, 3))),
    }
end

local BASE_BITERS_PER_REGION = 1
local function biters_per_region()
    return max(1, floor(BASE_BITERS_PER_REGION + Random.next_number(0, 5)))
end

local function biters_in_region(region_position)
    local biters_bases = {}
    Random.seed(region_position.x, region_position.y, RANDOM_PRIME)
    for i, position in pairs(
        RegionPositions.Unique(
            biters_per_region(),
            RegionPositions.OutsideStartingArea({
                    x = region_position.x * 32,
                    y = region_position.y * 32
                },
                RegionPositions.NextRandom(REGION_SIZE, 4)
            )
        )()
    ) do
        biters_bases[i] = next_base()
        biters_bases[i].x = position.x
        biters_bases[i].y = position.y
    end
    return WithDistanceBonus(
        biters_bases,
        region_position
    )
end

return Regionated(REGION_SIZE, biters_in_region)
