local Regionated = require("lua.util.worldgen.Regionated")
local RegionResources = require("lua.badlands.worldgen.decorations.resource.RegionResources")
local OreGenReport = require("lua.badlands.worldgen.analysis.CachedOreGenReport")
local QueuedToGenerate = require("lua.util.worldgen.analysis.surfaces.QueuedToGenerate")
local AnalysisSurface = require("lua.badlands.worldgen.analysis.surfaces.Nauvis")
local Queue = require("lua.badlands.tasks.BadlandsQueue")
local WithDistanceBonus = require("lua.util.worldgen.decorations.mods.DistanceBonus")

local REGION_SIZE = 32

local function resources_in_region(region_position)
    return WithDistanceBonus(
        RegionResources(
            region_position,
            REGION_SIZE,
            OreGenReport(
                QueuedToGenerate(
                    AnalysisSurface(),
                    Queue.queue()
        ))),
        region_position
    )
end

return Regionated(REGION_SIZE, resources_in_region)
