local RegionPositions = require("lua.util.worldgen.PositionsInRegions")
local Random = require("lua.util.Random")
local RANDOM_PRIME = 1051

local max = math.max
local floor = math.floor
local function next_deposit(available_resources, weight)
    if not weight then
        weight = 0
        for _, resource in pairs(available_resources) do
            weight = weight + resource.deposits
        end
    end
    local roll = Random.next_number(weight)
    local acc = 0
    for _, resource in pairs(available_resources) do
        acc = acc + resource.deposits
        if acc >= roll then
            return {
                name = resource.name,
                amount = max(1, floor(
                    resource.amount / resource.deposits
                    * (0.08 + 0.04 * (1 - Random.next_number()))
                )),
                area = max(1, floor(
                    resource.area / resource.deposits
                    * (0.3 + 0.3 * (1 - Random.next_number()))
                ))
            }
        end
    end
end

local deposits_per_region_cached
local function deposits_per_region()
    if not deposits_per_region_cached then
        local deposits = 0
        local total_frequency = 0
        local autoplace_controls = game.default_map_gen_settings.autoplace_controls
        for resource, _ in pairs(
            game.get_filtered_entity_prototypes({
                { filter = "type", type = "resource" },
                { filter = "autoplace", mode = "and" }
            })
        ) do
            total_frequency = total_frequency + autoplace_controls[resource].frequency
            deposits = deposits + 1
        end
        deposits_per_region_cached = 1 + 0.3 * total_frequency / deposits
    end
    return max(1, floor(deposits_per_region_cached + Random.next_number() * 0.9))
end

return function (region_position, region_size, available_resources)
    if available_resources then
        local deposits = {}
        Random.seed(region_position.x, region_position.y, RANDOM_PRIME)
        for i, position in pairs(
            RegionPositions.Unique(
                deposits_per_region(),
                RegionPositions.OutsideStartingArea({
                        x = region_position.x * 32,
                        y = region_position.y * 32
                    },
                    RegionPositions.NextRandom(region_size, 4)
                )
            )()
        ) do
            deposits[i] = next_deposit(available_resources)
            deposits[i].x = position.x
            deposits[i].y = position.y
        end
        return deposits
    end
end
