local GenerateResourceDeposit = require("lua.badlands.worldgen.structures.resources.Deposit")
local BadlandsDeposits = require("lua.badlands.worldgen.decorations.resource.BadlandsDeposits")
local TaskQueue = require("lua.badlands.tasks.BadlandsQueue")
local HighlightDepositTask = require("lua.badlands.tasks.HighlightDeposit").new

return function (chunk_position, surface)
    local deposit = BadlandsDeposits:in_chunk(chunk_position)
    if deposit then
        if deposit.name then
            GenerateResourceDeposit(
                surface, {
                    x = chunk_position.x * 32 + 16,
                    y = chunk_position.y * 32 + 16
                },
                deposit
            )
            TaskQueue.queue():add_task(
                HighlightDepositTask({
                        x = chunk_position.x,
                        y = chunk_position.y
                    },
                        surface
                    ),
                    TaskQueue.priorities.LOW
                )
        end
        return true
    end
end
