local Random = require("lua.util.Random")
local RANDOM_PRIME = 6491
local ATTEMPTS = 20
local RADIUS = 12


local COST_MULT = 0.05
local biters_entities = {
    ["worms"] = {
        ["small-worm-turret"] = 8,
        ["medium-worm-turret"] = 12,
        ["big-worm-turret"] = 16,
        ["behemoth-worm-turret"] = 20,
    },
    ["biters"] = {
        "biter-spawner",
        "spitter-spawner"
    }
}

local function with_biters_spawners(biters_base, entities)
    if biters_base.name == "biters" then
        entities = entities or {}
        for _ = 1, biters_base.area do
            entities[#entities+1] = biters_entities["biters"][
                Random.next_number() < 0.3 and 2 or 1
            ]
        end
    end
    return entities
end

local function with_worms_base_bonus(biters_base)
    if biters_base.name == "worms" then
        biters_base.amount = biters_base.amount * 1.1
        biters_base.area = biters_base.area * 8
    end
    return biters_base
end

local function worms_to_spawn(biters_base)
    local entities = {}
    for _ = 1, biters_base.area do
        local best_entity = biters_entities["worms"][1]
        local best_cost = 0
        for entity, cost in pairs(biters_entities["worms"]) do
            if cost <= biters_base.amount and cost > best_cost then
                best_entity = entity
                best_cost = cost
            end
        end
        if best_entity then
            entities[#entities+1] = best_entity
            biters_base.amount = biters_base.amount - best_cost * COST_MULT
        end
    end
    return entities
end

return function (surface, position, biters_base)
    Random.seed(position.x, position.y, RANDOM_PRIME)
    for _, biter in pairs(
        with_biters_spawners(
            biters_base,
            worms_to_spawn(
                with_worms_base_bonus(biters_base)
    ))) do
        for _ = 1, ATTEMPTS do
            local pos = {
                x = position.x + Random.next_number(-RADIUS, RADIUS),
                y = position.y + Random.next_number(-RADIUS, RADIUS)
            }
            pos = surface.find_non_colliding_position(
                biter, -- name
                pos, -- center
                6, -- radius
                4, -- precision
                true -- force_to_tile_center
            )
            if pos then
                surface.create_entity({
                    name = biter,
                    position = pos,
                })
                break
            end
        end
    end
end
