local TREES_ENTITIES = { -- "Weighted"
    "dry-tree",
    "dry-tree",
    "dry-tree",
    "dry-tree",
    "dead-grey-trunk",
    "dead-grey-trunk",
    "dead-dry-hairy-tree",
    "dead-tree-desert",
}

local Random = require("lua.util.Random")
local ATTEMPTS = 1
local RADIUS = 12

local function nonlinear_distance_in_radius(radius)
    return (1 - 2 * Random.next_number(1))
            * (Random.next_number(radius * radius) ^ 2 / radius ^ 3)
end

return function (surface, position, count)
    Random.seed(position.x, position.y)
    for _ = 1, (count or (20 + Random.next_number(10))) do
        local name = TREES_ENTITIES[Random.next_number(1, #TREES_ENTITIES)]
        for _ = 1, ATTEMPTS do
            local pos = {
                x = position.x + nonlinear_distance_in_radius(RADIUS) + RADIUS / 2,
                y = position.y + nonlinear_distance_in_radius(RADIUS) + RADIUS / 2
            }
            pos = surface.find_non_colliding_position(
                name, -- name
                pos, -- center
                RADIUS / 2, -- radius
                4, -- precision
                true -- force_to_tile_center
            )
            if pos then
                surface.create_entity({
                    name = name,
                    position = pos
                })
                break
            end
        end
    end
end
