local GenerateDeposit = require("lua.badlands.worldgen.structures.resources.Deposit")
local GeneratePond = require("lua.badlands.worldgen.structures.Pond")
local GenerateRocks = require("lua.badlands.worldgen.structures.Rocks")
local StartingResources = require("lua.badlands.worldgen.analysis.CachedOreGenReport")
local StartingSurface = require("lua.badlands.worldgen.analysis.surfaces.StartingArea")
local ForcedToGenerate = require("lua.util.worldgen.analysis.surfaces.ForcedToGenerate")
local Random = require("lua.util.Random")
local HighlightDepositTask = require("lua.badlands.tasks.HighlightDeposit").new
local GenerateDeadForest = require("lua.badlands.worldgen.structures.DeadForest")

local CRUDE_OIL_NAME = "crude-oil"
local floor = math.floor

local origin
local origin_surface
local starting_slot

local function calculated_position(slot)
    local radius = floor((slot - 1) / 4)
    local order = (slot - 1) % 4
    local xmod = order % 2
    local ymod = (order - xmod) / 2
    return {
        x = origin.x - 32 * (radius * (xmod * 2 - 1) + 1 * xmod) + 16,
        y = origin.y + 32 * (radius * (ymod * 2 - 1) + 1 * ymod) - 16
    }
end

local function with_oil(resources)
    -- for _, resource in pairs(resources) do
    --     if resource.name == CRUDE_OIL_NAME then return resources end
    -- end
    -- if game.entity_prototypes[CRUDE_OIL_NAME].autoplace_specification then
    --     local ac = game.default_map_gen_settings.autoplace_controls[CRUDE_OIL_NAME]
    --     Random.seed(011011)
    --     resources[#resources+1] = {
    --         name = CRUDE_OIL_NAME,
    --         amount = 150000 * (1
    --             + 0.5 * ac.richness
    --             + 0.3 * (ac.frequency + ac.size)
    --         ) * (1 + Random.next_number() * 0.5),
    --         area = floor(2
    --             * (1 + 0.1 * (ac.frequency + ac.size))
    --             * (1 + Random.next_number() * 0.3)
    --         )
    --     }
    -- end
    return resources
end

local function sorted_coal_third(resources)
    local sorted = {}
    local COAL_NAME = "coal"
    local coal = nil
    for _, resource in pairs(resources) do
        if resource.name == COAL_NAME then
            coal = resource
        else
            sorted[#sorted+1] = resource
        end
    end
    if coal then table.insert(sorted, 4, coal) end
    return sorted
end

local function resources_to_generate()
    local analysis_surface = StartingSurface()
    return with_oil(
        sorted_coal_third(
            StartingResources(
                ForcedToGenerate(
                    analysis_surface
                ),
                analysis_surface.radius * 2
            )
        )
    )
end

local function generate_resources(resources)
    local slot_i = starting_slot
    for _, resource in pairs(resources) do
        GenerateDeposit(origin_surface, calculated_position(slot_i), resource)
        HighlightDepositTask({
            x = floor(calculated_position(slot_i).x / 32),
            y = floor(calculated_position(slot_i).y / 32)
        }, origin_surface):executed()
        slot_i = slot_i + 1
    end
end

local function generate_rocks(resources)
    local slot = starting_slot
    for _, resource in pairs(resources) do
        if resource.name == "stone" then
            break
        end
        slot = slot + 1
    end
    GenerateRocks(
        origin_surface,
        calculated_position(
            slot <= (starting_slot + 4)
                and slot
                or starting_slot + Random.next_number(4)
        ))
end

return function (position, surface)
    if game.tick > 1000 then
        return
    end
    origin = position or { x = 0, y = 0 }
    origin_surface = surface
    starting_slot = 5
    local resources = resources_to_generate()
    generate_resources(resources)
    generate_rocks(resources)
    GenerateDeadForest(surface, { x = origin.x + 40, y = origin.x })
    GenerateDeadForest(surface, { x = origin.x + 32, y = origin.x - 12 })
    GeneratePond(surface, { x = origin.x - 16, y = origin.x + 48 }, 3)
end
