local Random = require("lua.util.Random")
local ATTEMPTS = 4
local RADIUS = 12
local RANDOM_EFFECT = 0.3

local max = math.max

return function (surface, position, resource)
    Random.seed(position.x, position.y)
    -- local amount = max(1, resource.amount / resource.area)
    local amount = max(1, resource.amount*2)
    for _ = 1, resource.area do
        for _ = 1, ATTEMPTS do
            local pos = {
                x = position.x + Random.next_number(-RADIUS + 6, RADIUS),
                y = position.y + Random.next_number(-RADIUS + 6, RADIUS)
            }
            pos = surface.find_non_colliding_position(
                resource.name, -- name
                pos, -- center
                6, -- radius
                4, -- precision
                true -- force_to_tile_center
            )
            if pos then
                surface.create_entity({
                    name = resource.name,
                    position = pos,
                    amount = amount * (1 + RANDOM_EFFECT * Random.next_number())
                })
                break
            end
        end
    end
end
