local min = math.min
local max = math.max
local sqrt = math.sqrt
local floor = math.floor
local function round(num)
    return floor(num * 2 - floor(num))
end

local function calculated_size(size)
    local spots = sqrt(size * 0.4 / (5 * 5))
    -- .,..X..,,..X..,.
    -- 1..4X1....6X1..4
    return {
        width = min(3 * 7 + 8, (max(1, round(spots)) - 1) * 7 + 8),
        height = min(3 * 7 + 8, (max(1, floor(spots)) - 1) * 7 + 8)
    }
end

local function generate_ore_in_area(surface, area, resource)
    -- Field
    local field_amount = max(100,
        (resource.amount * 0.05) / (area.width * area.height)
    )
    for x = 0, area.width do
        for y = 0, area.height do
            local halfWidth = area.width/2;
            local halfHeight = area.height/2;
            if((((x-halfWidth)*(x-halfWidth))/(halfWidth*halfWidth)+((y-halfHeight)*(y-halfHeight))/(halfHeight*halfHeight)) < 1)
            then
                surface.create_entity({
                    name = resource.name,
                    position = { area.x + x, area.y + y},
                    amount = field_amount
                })
            end
        end
    end
    -- Spots
    local spot_amount = max(1, resource.amount / (area.width * area.height / 49))
    for x = 1, area.width / 7 do
        for y = 1, area.height / 7 do
            surface.create_entity({
                name = resource.name,
                position = { area.x - 3 + x * 7, area.y - 3 + y * 7},
                amount = spot_amount
            })
        end
    end
end

return function (surface, position, resource)
    local size = calculated_size(resource.area);
    generate_ore_in_area(
        surface, {
            x = position.x - size.width / 2,
            y = position.y - size.height / 2,
            width = size.width,
            height = size.height
        },
        resource
    )
end
