local biters = require("lua.badlands.worldgen.decorations.biters.BadlandsBiters")

local function reveal_biters(region_position, biters_base)
    local c = {
        x = region_position.x * 32 * 32 + biters_base.x * 32,
        y = region_position.y * 32 * 32 + biters_base.y * 32,
    }
    for _, p in pairs(game.players) do
        p.force.chart(
            game.surfaces["nauvis"],
            { c, c }
        )
    end
end

local function region_report(region_position)
    local biters_bases = biters:in_region(region_position)
    for _, biters_base in pairs(biters_bases) do
        reveal_biters(region_position, biters_base)
    end
    return "Region ["
        .. region_position.x .. "; "
        .. region_position.y .. "] biters:\n"
        .. serpent.block(biters_bases, { sparse = true })
        .. "\n"
end

return function ()
    if biters:in_region({ x = 0, y = 0}) then
        local report = "-- BITERS BASES TEST:\n"
        local range = 1
        for x = -range, (range - 1) do
            for y = -range, (range - 1) do 
                report = report .. region_report({ x = x, y = y })
            end
        end
        return report
    end
end
