local test_deposits = require("lua.badlands.worldgen.decorations.resource.BadlandsDeposits")

local function reveal_deposit(region_position, deposit)
    local c = {
        x = region_position.x * 32 * 32 + deposit.x * 32,
        y = region_position.y * 32 * 32 + deposit.y * 32,
    }
    for _, p in pairs(game.players) do
        p.force.chart(
            game.surfaces["nauvis"],
            { c, c }
        )
    end
end

local function region_report(region_position)
    local deposits = test_deposits:in_region(region_position)
    for _, deposit in pairs(deposits) do
        reveal_deposit(region_position, deposit)
    end
    return "Region ["
        .. region_position.x .. "; "
        .. region_position.y .. "] resources:\n"
        .. serpent.block(deposits, { sparse = true })
        .. "\n"
end

return function ()
    if test_deposits:in_region({ x = 0, y = 0}) then
        local report = "-- REGION RESOURCES TEST:\n"
        local range = 1
        for x = -range, (range - 1) do
            for y = -range, (range - 1) do 
                report = report .. region_report({ x = x, y = y })
            end
        end
        return report
    end
end
