-- include this and call run()
local IngameTest = {}

local hr = "\n========================================\n"
local do_once = function(test)
    return setmetatable(
        { test = test },
        { __call = function (self)
            if not self.complete then
                local result = self.test()
                self.complete = result and true
                return result
            end
        end}
    )
end

local tests = {
    do_once(require("ShowRegisteredDecorations")),
    do_once(require("RegionResourcesTest")),
    do_once(require("ShowOregenAnalysis")),
    do_once(require("ShowQueue")),
    do_once(require("RegionBitersTest"))
}
local tick = 0

function IngameTest.run()
    if tick % 600 == 0 then
        local report = hr .. "              INGAME TESTS" .. hr
        local has_results = false
        for _, test in pairs(tests) do
            local treport = test()
            if treport then
                report = report .. treport .. hr
                has_results = true
            end
        end
        if has_results then log(report) end
    end
    tick = tick + 1
end

return IngameTest
