local TASK_TYPE = "TEST_TASK"
local test_task = {}
test_task.__index = test_task
test_task.new = function(a, b, c, d)
    return setmetatable({ c = a + b + c + d }, test_task)
end
test_task = require("lua.util.table.WithType").table(test_task, TASK_TYPE)
-- Queue
local test_queue = {}
test_queue.__index = test_queue
test_queue.add_task = function (self, task, a, b)
    return a, b
end
test_queue = require("lua.util.tasks.ImprintingType").queue(setmetatable({}, test_queue))

-- Start
local taskA = test_task.new(1, 2, 3, 4)
local a, b = test_queue:add_task(taskA, "one", 2)
assert(a == "one" and b == 2, "queue method intercept test")
taskA = setmetatable(taskA, nil)
assert(taskA.type == TASK_TYPE and taskA.c == 1 + 2 + 3 + 4, "task instance type test")

print("TaskWithType Test: ok")
