local tr = require("lua.util.tasks.Registry")
local twt = require("lua.util.tasks.TaskWithType")

local task_type = "TEST_TASK"
local tt = twt(task_type)
tt.__index = tt
tt.executed = function(self) self.c = self.c + 1 return self.c < 10 and self or nil end
tt.new = function (c) return tt({ c = 0 }) end

-- unload task test
tr.register_task(tt)
local taskA = tt.new()
taskA:executed()
taskA = setmetatable(taskA, nil)
assert(not pcall(function (t) t:executed() end, taskA), "task unload test")
-- load task test
taskA = tr.loaded_task(taskA)
assert(pcall(function (t) t:executed() end, taskA), "task load test")
assert(taskA.c == 2, "loaded task execution test")

print("TaskRegistry Test: ok")
