local tq = require("lua.util.tasks.Queue").new()

local tt = {}
tt.__index = tt
tt.executed = function(self) self.c = self.c + 1 return self.c < 10 and self or nil end
local test_task = function () return setmetatable({ c = 0 }, tt) end

local function update_queue(times) for _=1,times do tq:tick() end end

-- task update test
local taskA = test_task()
tq:add_task(taskA)
update_queue(100)
assert(taskA.c == 10, "task update test")
-- priority test
taskA = test_task()
tq:add_task(taskA)
tq:add_task(test_task(), tq.priorities.HIGH)
update_queue(10)
assert(taskA.c == 0, "priority test step A")
update_queue(10)
assert(taskA.c == 10, "priority test step B")
-- queue tasks test
tq:add_task(test_task())
taskA = test_task()
tq:add_task(taskA)
update_queue(10)
tq:add_task(test_task())
tq:add_task(test_task())
update_queue(10)
assert(taskA.c == 10, "queue test")
update_queue(20)

print("TaskQueue Test: ok")
