local Regionated = require("lua.util.worldgen.Regionated")
local fill = function (position)
    return { x = position.x, y = position.y }
end

local function cycle(regions, func)
    for x = -1, 0 do
        for y = -1, 0 do
            func(regions, x, y)
        end
    end
end

local test_regions = Regionated(32, fill)
cycle(test_regions, function (regions, x, y)
    regions:in_region({ x = x, y = y })
end)

cycle(test_regions, function (regions, x, y)
    local r = regions:in_region({ x = x, y = y })
    assert(r.x == x and r.y == y, "Region retrieve test")
end)

print("Regionated Test: ok")
