local sm = require("lua.util.worldgen.analysis.samples.SamplesMap").new()
local cs = require("lua.util.worldgen.analysis.samples.CombinedSamples").Test()
local sp = require("lua.util.worldgen.analysis.samples.SamplePosition")
local Util = require("lua.util.Util")

local samples = {
    { x = 0, y = 0, sample = { amount = 8, area = 1 } },
    { x = 0, y = -1, sample = { amount = 20, area = 2 } },
    { x = -1, y = -1, sample = { amount = 50, area = 3 } },
    { x = -1, y = 0, sample = { amount = 150, area = 4 } },
    { x = 14, y = 88, sample = { amount = 228, area = 10 } }
}
local function loop(tbl, fnc) for a,b in pairs(tbl) do fnc(a,b) end end

-- fill
loop(samples, function(_, s) sm:with_sample(s.x, s.y, s.sample) end)

-- neighbours test
local neigbours = cs.sample_neighbours({
        x = samples[1].x,
        y = samples[1].y,
        hash = sp.from_xy(samples[1].x, samples[1].y)
    }, sm
)
assert(Util.table_length(neigbours) == 4, "neighbour test")
-- combine test
local combined = cs.list(sm)
loop(cs.list(sm), function(_, s)
    assert(
        Util.table_length(combined) == 4
        and s.amount == 228
        and s.area == 10,
        "combined test"
    )
end)

print("CombinedSamples Test: ok")
