local sm = require("lua.util.worldgen.analysis.samples.SamplesMap").new()

local samples = {
    { x = 0, y = 0, sample = "sample1" },
    { x = 0, y = -1, sample = "sample2" },
    { x = -1, y = -1, sample = "sample3" },
    { x = -1, y = 0, sample = "sample4" },
    { x = 14, y = 88, sample = "sample228" }
}
local function loop(tbl, fnc) for a,b in pairs(tbl) do fnc(a,b) end end

-- fill
loop(samples, function(_, s) sm:with_sample(s.x, s.y, s.sample) end)
-- with_sample test
loop(samples, function(_, s) assert(sm:sample_at(s.x, s.y) == s.sample, "with_sample") end)
-- pairs test
loop(sm, function(pos, sample) assert(sm:sample_at(pos.x, pos.y) == sample, "pairs") end)

print("SamplesMap Test: ok")
