local Random = {}

local PRIME_ONE = 374764979
local PRIME_TWO = 774815501
local MAX_INTEGER = 4294967295
local band = bit32.band

local rng
local initial_seed

function Random.next_number(lower, upper)
    return lower and (upper
            and rng(lower, upper)
            or rng(lower))
            or rng()
end

local function seed_(a, b, c)
    rng.re_seed(band(MAX_INTEGER,
            initial_seed
            + a * PRIME_ONE
            + (b or 1) * PRIME_TWO
            + (c or 0)
    ))
    return Random
end

function Random.seed(a, b, c)
    initial_seed = game.default_map_gen_settings.seed
    rng = game.create_random_generator()
    Random.seed = seed_
    return Random.seed(a, b)
end

return Random
