local Util = {}

function Util.area_xywh(x, y, w, h)
    return { top_left = { x = x, y = y }, right_bottom = { x = x + w, y = y + h} }
end

function Util.xy_within_area(x, y, area)
    return x >= area.top_left.x
            and x <= area.right_bottom.x
            and y >= area.top_left.y
            and y <= area.right_bottom.y
end

function Util.region_quads(area)
    local areas = {}
    local size = (area.right_bottom.x - area.top_left.x) / 2
    local c = area.top_left
    for x = 0, 1 do
        for y = 0, 1 do
            areas[#areas + 1] = Util.area_xywh(c.x + x * size, c.y + y * size, size, size)
        end
    end
    return areas
end

function Util.table_length(table)
    local length = 0
    for _, __ in pairs(table) do
        length = length + 1
    end
    return length
end

function Util.table_with_default(default_value)
    return setmetatable({}, { __index = function (self, key)
        self[key] = not default_value
                and {}
                or type(default_value) == "function"
                and default_value()
                or default_value
        return self[key]
    end})
end

return Util
