local Queue = {}
Queue.__index = Queue

local TasksRegistry = require("lua.util.tasks.Registry")

function Queue:tick()
    local i, task = next(self.tasks)
    if task then self.tasks[i] = task:executed() end
    return i
end

function Queue:add_task(task)
    self.i_last = next(self.tasks) and (self.i_last + 1) or 1
    self.tasks[self.i_last] = task
end

local function load_tasks(tasks)
    for i, task in pairs(tasks) do tasks[i] = TasksRegistry.loaded_task(task) end
end

function Queue.new(old_queue)
    local queue = old_queue or { tasks = {}, i_last = 1 }
    load_tasks(queue.tasks)
    return setmetatable(queue, Queue)
end

local QueueWithPriorities = {
    priorities = {
        HIGH = 1,
        NORMAL = 2,
        LOW = 3
    }
}
QueueWithPriorities.__index = QueueWithPriorities

function QueueWithPriorities:tick()
    for i, _ in ipairs(self) do
        if self[i]:tick() then return end
    end
end

function QueueWithPriorities:add_task(task, priority)
    self[priority or QueueWithPriorities.priorities.NORMAL]:add_task(task)
end

function QueueWithPriorities:with_task(task, priority)
    self:add_task(task, priority)
    return self
end

function QueueWithPriorities.new(old_queue)
    local queue = old_queue or {}
    for _, p in pairs(QueueWithPriorities.priorities) do
        queue[p] = Queue.new(queue[p])
    end
    return setmetatable(queue, QueueWithPriorities)
end

return QueueWithPriorities
