local RegionPositions = {}

local Random = require("lua.util.Random")
local Util = require("lua.util.Util")

local function next_random(self)
    return {
        x = Random.next_number(self.margin, self.region_size - 1 - self.margin),
        y = Random.next_number(self.margin, self.region_size - 1 - self.margin)
    }
end
function RegionPositions.NextRandom(region_size, margin)
    return setmetatable({
        region_size = region_size,
        margin = margin
    }, { __call = next_random })
end

local STARTING_AREA_SIZE = 20
local STARTING_AREA_ATTEMPTS = 200
local starting_area = Util.area_xywh(
    -STARTING_AREA_SIZE, -STARTING_AREA_SIZE,
    2 * STARTING_AREA_SIZE, 2 * STARTING_AREA_SIZE
)
local function outside_starting_area(self)
    local attempt = 0
    local position
    while not position and attempt < STARTING_AREA_ATTEMPTS do
        attempt = attempt + 1
        position = self.position()
        if Util.xy_within_area(
            self.origin.x + position.x,
            self.origin.y + position.y,
            starting_area
        ) then
            position = nil
        end
    end
    return position
end
function RegionPositions.OutsideStartingArea(origin, position_func)
    return setmetatable({
        origin = origin,
        position = position_func
    }, { __call = outside_starting_area })
end

local UNIQUE_POSITIONS_ATTEMPTS = 200
local function unique_positions(self)
    local positions = {}
    local attempt = 0
    while #positions < self.count and attempt < UNIQUE_POSITIONS_ATTEMPTS do
        attempt = attempt + 1
        local position = self.position()
        for _, pos in pairs(positions) do
            if pos.x == position.x and pos.y == position.y then
                position = nil
                break
            end
        end
        positions[#positions+1] = position
    end
    return positions
end
function RegionPositions.Unique(count, position_func)
    return setmetatable({
        count = count,
        position = position_func
    }, { __call = unique_positions })
end

return RegionPositions
