local TableWithDefault = require("lua.util.Util").table_with_default
local floor = math.floor

local function in_region(self, region_position)
    self.regions[region_position.x][region_position.y] =
            self.regions[region_position.x][region_position.y]
            or self.fill_region(region_position)
    return self.regions[region_position.x][region_position.y]
end

local function in_chunk(self, chunk_position)
    local resources = self:in_region({
        x = floor(chunk_position.x / self.region_size),
        y = floor(chunk_position.y / self.region_size)
    })
    if resources then
        for _, deposit in pairs(resources) do
            if deposit.x == chunk_position.x % 32 and deposit.y == chunk_position.y % 32 then
                return deposit
            end
        end
        return {} -- no deposit
    end
end

return function (region_size, fill_function)
    local metatable = {
        in_region = in_region,
        in_chunk = in_chunk,
        region_size = region_size,
        fill_region = fill_function,
        regions = TableWithDefault()
    }
    metatable.__index = metatable
    return setmetatable({}, metatable)
end
