local SurfaceSamples = require("lua.util.worldgen.analysis.samples.SurfaceSamples")
local CombinedSamples = require("lua.util.worldgen.analysis.samples.CombinedSamples")
local Util = require("lua.util.Util")

local function resource_report(resource_name, samples_map)
    local report = { name = resource_name, amount = 0, area = 0, deposits = 0 }
    for _, combined_sample in pairs(CombinedSamples.list(samples_map)) do
        report.amount = report.amount + combined_sample.amount
        report.area = report.area + combined_sample.area
        report.deposits = report.deposits + 1
    end
    return report
end

return function(surface, precision)
    local size = surface.map_gen_settings.width
    local report = {}
    for resource_name, samples_map in pairs(
        SurfaceSamples.maps_list(
            surface,
            Util.area_xywh(-size, -size, size * 2, size * 2),
            (precision or 0.5) * 32
    )) do
        report[#report+1] = resource_report(resource_name, samples_map)
    end
    return report
end
