local CombinedSamples = {}
CombinedSamples.__index = CombinedSamples

local SamplePosition = require("lua.util.worldgen.analysis.samples.SamplePosition")

local function sample_neighbours(position, sample_map, neighbours)
    neighbours = neighbours or { [position.hash] = sample_map:sample(position.hash) }
    for x = -1, 1 do
        for y = -1, 1 do
            local neighbour_pos = SamplePosition.from_xy(position.x + x, position.y + y)
            if not neighbours[neighbour_pos] then
                neighbours[neighbour_pos] = sample_map:sample(neighbour_pos)
                if neighbours[neighbour_pos] then
                    neighbours = sample_neighbours({
                            x =  position.x + x,
                            y = position.y + y
                        },
                        sample_map,
                        neighbours
                    )
                end
            end
        end
    end
    return neighbours
end

function CombinedSamples.list(samples_map)
    local samples = {}
    for pos, _ in pairs(samples_map) do
        local neighbours = sample_neighbours(pos, samples_map)
        local combined = { amount = 0, area = 0 }
        for npos, nsample in pairs(neighbours) do
            combined.amount = combined.amount + nsample.amount
            combined.area = combined.area + nsample.area
            local x, y = SamplePosition.to_xy(npos)
            samples_map = samples_map:with_sample(x, y, nil)
        end
        samples[#samples + 1] = combined
    end
    return samples
end

function CombinedSamples.Test()
    local test = { sample_neighbours = sample_neighbours }
    return setmetatable(test, CombinedSamples)
end

return CombinedSamples
