local SamplePosition = {}

local lshift = bit32.lshift
local rshift = bit32.rshift
local band = bit32.band

function SamplePosition.from_xy(x, y)
    return lshift(0x7fff - x, 16) + 0x7fff - y
end

function SamplePosition.to_xy(sample_position)
    return 0x7fff - rshift(sample_position, 16), 0x7fff - band(sample_position, 0xffff)
end

return SamplePosition
