local SamplesMap = {}
SamplesMap.__index = SamplesMap

local SamplePosition = require("lua.util.worldgen.analysis.samples.SamplePosition")

function SamplesMap:sample(hash)
    return self.samples[hash]
end

function SamplesMap:sample_at(x, y)
    return self:sample(SamplePosition.from_xy(x, y))
end

function SamplesMap.__pairs(self)
    local function next_sample(self, position)
        local position_hash, sample = next(
            self.samples,
            position and position.hash or nil
        )
        if sample then
            local x, y = SamplePosition.to_xy(position_hash)
            return { x = x, y = y, hash = position_hash }, sample
        end
    end
    return next_sample, self, nil
end

function SamplesMap:with_sample(x, y, sample)
    self.samples[SamplePosition.from_xy(x, y)] = sample
    return self
end

-- Ctor

function SamplesMap:new()
    local samples_map = {}
    samples_map.samples = {}
    return setmetatable(samples_map, SamplesMap)
end

return SamplesMap
