local SurfaceSamples = {}

local SamplesMap = require("lua.util.worldgen.analysis.samples.SamplesMap")
local Util = require("lua.util.Util")

local function area_has_resources(surface, area)
    return surface.count_entities_filtered({ type = "resource", area = area }) > 0
end

local function samples(surface, area)
    local samples_ = {}
    for _, resource in pairs(surface.find_entities_filtered({
            area = area,
            type = "resource",
            collision_mask = "resource-layer"
    })) do
        if Util.xy_within_area(resource.position.x, resource.position.y, area) then
            samples_[resource.name] = samples_[resource.name] or { amount = 0, area = 0 }
            samples_[resource.name].amount = samples_[resource.name].amount + resource.amount
            samples_[resource.name].area = samples_[resource.name].area + 1
        end
    end
    return samples_
end

local function subregion_samples(surface, area, precision, samples_maps)
    if area_has_resources(surface, area) then
        if (area.right_bottom.x - area.top_left.x) > precision then
            for _, subregion in pairs(Util.region_quads(area)) do
                samples_maps = subregion_samples(surface, subregion, precision, samples_maps)
            end
        else
            for resource, sample in pairs(samples(surface, area)) do
                samples_maps[resource] = samples_maps[resource] or SamplesMap.new()
                samples_maps[resource] = samples_maps[resource]:with_sample(
                    area.top_left.x / precision,
                    area.top_left.y / precision,
                    sample
                )
            end
        end
    end
    return samples_maps
end

function SurfaceSamples.maps_list(surface, area, precision)
    return subregion_samples(surface, area, precision, {})
end

return SurfaceSamples
