local NAME_SUFFIX = "_oregen_analysis"

local function new_surface(name, radius, mgs)
    mgs.width = radius * 32 * 2
    mgs.height = mgs.width
    return game.create_surface(name, mgs)
end

return function (name, radius, mgs)
    return setmetatable({
        name = name,
        radius = radius,
        surface = game.surfaces[name .. NAME_SUFFIX] or new_surface(name .. NAME_SUFFIX, radius, mgs),
    }, {
        __index = function (self, key)
            return self.surface[key]
        end
    })
end
