local function corrected(coordinate)
    return coordinate + (coordinate < 0 and 1 or 0)
end

local sqrt = math.sqrt
local function distance(region_position)
    return sqrt(
        corrected(region_position.x) * corrected(region_position.x)
        + corrected(region_position.y) * corrected(region_position.y)
    )
end

local floor = math.floor
return function(decoratives, region_position)
    for _, decorative in pairs(decoratives or {}) do
        decorative.amount = decorative.amount and
            floor(decorative.amount * (1 + distance(region_position) / 3))
        decorative.area = decorative.area and
            floor(decorative.area * (1 + distance(region_position) / 16))
    end
    return decoratives
end
