local MapGen = require("lua.badlands.MapGen")
local decoratives = require("prototypes.noise-expressions.decoratives")

local function with_badlands_worldgen(pe_names)
    pe_names[MapGen.BADLANDS_WORLDGEN_FLAG] = 1
    -- With disabled default ore generation
    for name, resource in pairs(data.raw.resource) do
        if resource.autoplace then
           pe_names["entity:" .. name .. ":probability"] = 0
        end
    end
    -- -- With disabled natural biters generation
    -- for name, spawner in pairs(data.raw["unit-spawner"]) do
    --     if spawner.autoplace then
    --         pe_names["entity:" .. name .. ":probability"] = 0
    --     end
    -- end
    for name, worm in pairs(data.raw.turret) do
        if worm.autoplace then
            pe_names["entity:" .. name .. ":probability"] = 0
        end
    end
    -- With decreased probability of decoratives
    for name, expression_name in pairs(decoratives) do
        pe_names["entity:" .. name .. ":probability"] = expression_name
    end
    return pe_names
end

data.raw["map-gen-presets"]["default"]["badlands"].basic_settings.property_expression_names =
        with_badlands_worldgen(
            data.raw["map-gen-presets"]
                    ["default"]
                    ["badlands"].basic_settings.property_expression_names
        )
