local PROPERTY_EXPRESSION_NAMES = {}

local BADLANDS_PREFIX = "badlands-"
local noise = require("noise")

local function nnes_group_autoplace_probability_effect(group, effect)
    for _, name in pairs(group.names) do
        if data.raw[group.type][name].autoplace then
            data:extend({{
                type = "noise-expression",
                name = BADLANDS_PREFIX .. name,
                expression = noise.define_noise_function(function(x, y, tile, map)
                    return noise.autoplace_probability(data.raw[group.type][name].autoplace) * effect
                end)
            }})
            PROPERTY_EXPRESSION_NAMES[name] = BADLANDS_PREFIX .. name
        end
    end
end

local function group_by_type(type)
    local group = { type = type, names = {} }
    for name,_ in pairs(data.raw[type]) do
        group.names[#group.names+1] = name
    end
    return group
end

nnes_group_autoplace_probability_effect({
    type = "simple-entity",
    names = {
        "sand-rock-big",
        "rock-huge",
        "rock-big"
    }
}, 0.1)
nnes_group_autoplace_probability_effect(group_by_type("tree"), 0.15)

return PROPERTY_EXPRESSION_NAMES
