local PROPERTY_EXPRESSION_NAMES = require("lua.badlands.MapGen").property_expressions

local noise = require("noise")
local tne = noise.to_noise_expression

local function no_starting_area_red_desert(elevation, tile, area_size, min_elevation)
    local distance_effect = noise.clamp(1 - (tile.distance / area_size), 0, 1)
    return elevation - distance_effect * (elevation - min_elevation)
end

local function no_starting_area_cliffs(elevation, tile, area_size, min_elevation)
    local distance_effect = noise.clamp(area_size - tile.distance, 0, 1)  -- step filter
    return elevation - distance_effect * (elevation - min_elevation)
end

local function finish_elevation(elevation, map, tile)
    local no_water = noise.max(100, elevation + tne(95))
    return no_starting_area_cliffs(no_water, tile, 512, 100)
end

-- Elevation
data:extend({{
    type = "noise-expression",
    name = PROPERTY_EXPRESSION_NAMES.elevation,
    expression = noise.define_noise_function(function(x, y, tile, map)
        local basis_noise = {
            type = "function-application",
            function_name = "factorio-basis-noise",
            arguments = {
                x = noise.var("x"),
                y = noise.var("y"),
                seed0 = tne(noise.var("map_seed")),
                seed1 = tne(3),
                input_scale = tne(noise.var("segmentation_multiplier") / 120),
                output_scale = tne(30)
            }
        }
        return finish_elevation(basis_noise, map, tile)
    end)
}})

-- Temperature
data:extend({{
    type = "noise-expression",
    name = PROPERTY_EXPRESSION_NAMES.temperature,
    expression = tne(40)
}})

-- Moisture
data:extend({{
    type = "noise-expression",
    name = PROPERTY_EXPRESSION_NAMES.moisture,
    expression = tne(0)
}})

-- Aux
data:extend({{
    type = "noise-expression",
    name = PROPERTY_EXPRESSION_NAMES.aux,
    expression = noise.define_noise_function(function(x, y, tile, map)
        local basis_noise = {
            type = "function-application",
            function_name = "factorio-basis-noise",
            arguments = {
                x = noise.var("x"),
                y = noise.var("y"),
                seed0 = tne(noise.var("map_seed")),
                seed1 = tne(3),
                input_scale = tne(noise.var("segmentation_multiplier") / 120),
                output_scale = tne(0.5)
            }
        }
        basis_noise = tne(0.71) + ((basis_noise + tne(0.5)) * tne(0.18))
        return no_starting_area_red_desert(basis_noise, tile, 512, 0.9)
    end)
}})

return PROPERTY_EXPRESSION_NAMES
