// DOWNSAMPLE=4
// BlurSamples=4
// USE_ADAPTATION=0
// USE_HDR_BLOOM=0
#line 1 "unknown"

#line 1 "F:\GAME\The Last of Us Part I\ReShade\Shaders\TrueHDR.fx"
#line 1 "F:\GAME\The Last of Us Part I\ReShade\Shaders\ReShade.fxh"
#line 50
namespace ReShade
{
#line 61
static const float AspectRatio = 2560 * (1.0 / 1440);
static const float2 PixelSize = float2((1.0 / 2560), (1.0 / 1440));
static const float2 ScreenSize = float2(2560, 1440);
#line 67
texture BackBufferTex : COLOR;
texture DepthBufferTex : DEPTH;
#line 70
sampler BackBuffer { Texture = BackBufferTex; };
sampler DepthBuffer { Texture = DepthBufferTex; };
#line 74
float GetLinearizedDepth(float2 texcoord)
{
#line 79
texcoord.x /= 1;
texcoord.y /= 1;
#line 84
texcoord.x -= 0 / 2.000000001;
#line 89
texcoord.y += 0 / 2.000000001;
#line 91
float depth = tex2Dlod(DepthBuffer, float4(texcoord, 0, 0)).x * 1;
#line 100
const float N = 1.0;
depth /= 1000.0 - depth * (1000.0 - N);
#line 103
return depth;
}
}
#line 108
void PostProcessVS(in uint id : SV_VertexID, out float4 position : SV_Position, out float2 texcoord : TEXCOORD)
{
texcoord.x = (id == 2) ? 2.0 : 0.0;
texcoord.y = (id == 1) ? 2.0 : 0.0;
position = float4(texcoord * float2(2.0, -2.0) + float2(-1.0, 1.0), 0.0, 1.0);
}
#line 2 "F:\GAME\The Last of Us Part I\ReShade\Shaders\TrueHDR.fx"
#line 1 "F:\GAME\The Last of Us Part I\ReShade\Shaders\ReShadeUI.fxh"
#line 3 "F:\GAME\The Last of Us Part I\ReShade\Shaders\TrueHDR.fx"
#line 7
static const int2 AdaptResolution = 256;
static const int AdaptMipLevels = 9;
#line 26
static const float sigma = float(4) / 2.0;
static const float double_pi = 6.283185307179586476925286766559;
static const int2 DownsampleAmount = 4;
#line 30
uniform float FrameTime < source = "frametime";>;
#line 32
static const float EPSILON = 1e-3;
#line 36
uniform float ToeStrength
<
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_step    = 0.01;
ui_label = "Toe Strength";
ui_min = 0.0;
ui_max = 1.0;
> = 0.0;
#line 46
uniform float ToeLength
<
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_step    = 0.01;
ui_label = "Toe Length";
ui_min = 0.0;
ui_max = 1.0;
> = 1.0;
#line 56
uniform float ShoulderStrength
<
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_step    = 0.01;
ui_label = "Shoulder Strength";
ui_min = 0.0;
ui_max = 3.0;
> = 0.0;
#line 66
uniform float ShoulderLength
<
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_step    = 0.01;
ui_label = "Shoulder Length";
ui_min = 0.0;
ui_max = 3.0;
> = 0.0;
#line 76
uniform float ShoulderAngle
<
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_step    = 0.01;
ui_label = "Shoulder Angle";
ui_min = 0.0;
ui_max = 3.0;
> = 0.0;
#line 87
uniform float Gamma<
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_label = "Gamma";
ui_min = 0.0;
ui_max = 5.0;
ui_step    = 0.01;
> = 1.0;
#line 96
uniform float brightness <
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_label = "Brightness";
ui_min = -1.0;
ui_max = 1.0;
ui_step    = 0.01;
> = 0.0;
#line 114
uniform float BlackPoint <
ui_category = "Filmic Tonemap";
ui_type = "slider";
ui_step = 0.01;
ui_min = 0.0; ui_max = 1.0;
ui_label = "Black Point";
ui_tooltip = "The black point is the new black - literally. Everything darker than this will become completely black.";
> = 0.0;
#line 123
uniform float  HDRPower <
ui_category = "Filmic Tonemap";
ui_label   = "Local ToneMapping";
ui_type = "slider";
ui_min     = 0;
ui_max     = 1.0;
ui_step    = 0.01;
> = 0.0;
#line 132
uniform float  sldClarity <
ui_category = "Filmic Tonemap";
ui_label   = "Clarity";
ui_type = "slider";
ui_min     = 0;
ui_max     = 1.0;
ui_step    = 0.01;
> = 0.81;
#line 141
uniform float Exposure<
ui_category = "High-Dynamic Range";
ui_type = "slider";
ui_step    = 1.0;
ui_label = "HDR Exposure";
ui_min = 0.0;
ui_max = 5.0;
> = 0.0;
#line 150
uniform float HDR_WHITEPOINT <
ui_category = "High-Dynamic Range";
ui_type = "slider";
ui_step = 1.0;
ui_min = 1.0; ui_max = 100.0;
ui_label = "HDR Whitepoint";
> = 50.0;
#line 239
texture texBlur
{
Width = 2560 / DownsampleAmount.x;
Height = 1440 / DownsampleAmount.y;
Format = RGBA16F;
};
#line 246
sampler SamplerBlur { Texture = texBlur; };
#line 339
float3 srgb_to_linear(float3 srgb)
{
return (srgb < 0.04045) ? srgb / 12.92 : pow(abs((srgb + 0.055) / 1.055), 2.4);
}
#line 344
float3 linear_to_srgb(float3 lin)
{
return (lin < 0.0031308) ? 12.92 * lin : 1.055 * pow(abs(lin), 0.41666666) - 0.055;
}
#line 350
float3 srgb_to_acescg(float3 srgb)
{
float3x3 m = float3x3(  0.613097, 0.339523, 0.047379,
0.070194, 0.916354, 0.013452,
0.020616, 0.109570, 0.869815);
return mul(m, srgb);
}
#line 358
float3 acescg_to_srgb(float3 acescg)
{
float3x3 m = float3x3(  1.704859, -0.621715, -0.083299,
-0.130078,  1.140734, -0.010560,
-0.023964, -0.128975,  1.153013);
return mul(m, acescg);
}
#line 366
float3 sdr_to_hdr(float3 color, float w)
{
float toe_length = pow(abs(ToeLength), 2.2);
color = (color - ToeStrength) / (1.0f - ToeStrength) * toe_length;
#line 371
float a = 1.04f + exp2(-w);
#line 373
color = color * rcp(a - saturate(color));
color = color * (1.0 - 0.48) + 0.48;
return color;
}
#line 378
float3 sdr_to_hdr_lum(float3 color, float w)
{
float lum = dot(color, float3(0.299, 0.587, 0.114));
float a = 1.04f + exp2(-w);
color *= lum * rcp(a - saturate(lum));
return color;
}
#line 386
float3 hdr_to_sdr(float3 color, float w)
{
float a = 1.04f + exp2(-w);
#line 390
color = pow(color, Gamma);
float extra_w = exp2(ShoulderStrength);
float toe_length = pow(abs(ToeLength), 2.2);
color = color * ((ShoulderStrength * color + 1.0 + ShoulderLength) + extra_w) / (ShoulderAngle * color + ToeStrength + 1.0);
#line 395
color *= 1.0 + brightness;
#line 397
color = a * color * rcp(color + 1.0);
#line 399
return color;
}
#line 404
float gaussian_function(float2 i) {
static const float first_part = 1.0 / (double_pi * pow(sigma, 2.0));
static const float second_part_a = 1.0 / (2.0 * pow(sigma, 2.0));
float second_part_b = (pow(i.x, 2.0) + pow(i.y, 2.0)) * second_part_a;
return first_part * exp(-second_part_b);
}
#line 411
float3 blur(sampler sp, float2 uv, float scale) {
float2 ps = rcp(ReShade::ScreenSize) * scale;
#line 414
float accum = 0.0;
float gaussian_weight = 0.0;
float3 col = 0.0;
#line 418
[loop]
for (int x = -4; x <= 4; ++x) {
for (int y = -4; y <= 4; ++y) {
gaussian_weight = gaussian_function(float2(x, y));
accum += gaussian_weight;
col += tex2D(sp, uv + ps * float2(x, y)).rgb * gaussian_weight;
}
}
#line 427
return col / accum;
}
#line 462
void PS_LargeBlur(in float4 position : SV_POSITION, in float2 uv : TEXCOORD, out float4 color : SV_Target)
{
color = blur(ReShade::BackBuffer, uv, 4);
}
#line 515
float4 MainPS(float4 p : SV_POSITION, float2 uv : TEXCOORD) : SV_TARGET
{
float4 color = tex2D(ReShade::BackBuffer, uv);
#line 519
float3 largeblur = blur(SamplerBlur, uv, 16);
float ar = dot(color, float3(0.299, 0.587, 0.114));
float br = dot(largeblur, float3(0.299, 0.587, 0.114));
#line 523
float Clarity = (0.5 + ar - br);
Clarity = lerp(2 * Clarity + ar * (1 - 2 * Clarity), 2 * (1 - Clarity) + (2 * Clarity - 1) * rsqrt(ar), ar > br);
color *= lerp(1.0, Clarity, sldClarity);
#line 527
color = srgb_to_linear(color);
color *= sdr_to_hdr(color, HDR_WHITEPOINT);
color *= exp2(Exposure);
#line 551
br = log(br);
float sqrta = sqrt(ar);
float HDRToning = sqrta * lerp(sqrta*(2*ar*br-ar-2*br+2.0), (2*sqrta*br-2*br+1), br > 0.5);
color = color / (ar+1e-6) * lerp(ar, HDRToning, HDRPower);
#line 556
color = hdr_to_sdr(color, HDR_WHITEPOINT);
color = linear_to_srgb(color);
color = (color - BlackPoint) / (1.0f - BlackPoint);
#line 560
return color;
}
#line 566
technique TrueHDR
{
pass  {
VertexShader = PostProcessVS;
PixelShader = PS_LargeBlur;
RenderTarget = texBlur;
}
#line 626
pass
{
VertexShader = PostProcessVS;
PixelShader = MainPS;
}
#line 632
}

