local assets = 
{
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
	    Asset("ANIM", "anim/player_wolfgang.zip"),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
				
        Asset("ANIM", "anim/pumpkin_pet.zip"),
		
	    Asset("ATLAS", "images/inventoryimages/pumpkin_pet.xml"),
	    Asset("IMAGE", "images/inventoryimages/pumpkin_pet.tex"),			
}

local prefabs = {"twigs",}

local items = {"twigs"}

SetSharedLootTable( 'pumpkin_pet',{{'twigs',   1.0},	{'twigs',   1.0},{'twigs',   1.0},{'twigs',   1.0},	{'twigs',   1.0},{'twigs',   1.0},	{'twigs',   1.0},	{'twigs',   1.0},{'twigs',   1.0},{'twigs',   1.0},{'twigs',   0.5},{'twigs',   0.5},})

local function OnNewTarget(inst, data) 
end

local function onhit(inst)
        inst.components.follower:StopFollowing()    
    inst.SoundEmitter:PlaySound("dontstarve/creatures/werepig/hurt")
end

local function ondeath(inst)
	local player = GetPlayer()
	if player then
        inst.SoundEmitter:PlaySound("dontstarve/creatures/werepig/death")
		local pt = inst:GetPosition()
	end
end

local function KeepTarget(isnt, target)
    return target and target:IsValid()
end

local function KeepTarget(isnt, target)
    return target and target:IsValid()
end

local function entitydeathfn(inst, data)
    if data.inst:HasTag("player") then
        inst:DoTaskInTime(math.random(), function() inst.components.health:Kill() end)
        inst.SoundEmitter:PlaySound("dontstarve/creatures/werepig/death")
        inst.SoundEmitter:KillSound("idle")
		local pt = inst:GetPosition()
    end
end

local function ShouldAcceptItem(inst, item)
	if (item.prefab == "twigs") then   
        	return true
			end
	    	if item.components.equippable and (item.components.equippable.equipslot == EQUIPSLOTS.HANDS or item.components.equippable.equipslot == EQUIPSLOTS.BODY) and not item.components.projectile then
		if item.prefab == "telestaff" then
			print ("refusing telestaff")
			return false
		end		
		    return true
    end
end

local function OnGetItemFromPlayer(inst, giver, item)

           	if item.components.equippable and ( item.components.equippable.equipslot == EQUIPSLOTS.HANDS or item.components.equippable.equipslot == EQUIPSLOTS.BODY)   then     
			
		local newslot = item.components.equippable.equipslot
		local current = inst.components.inventory:GetEquippedItem(newslot)
		if current then
            		inst.components.inventory:DropItem(current)
        	end      
        	inst.components.inventory:Equip(item)
			
	    elseif (item.prefab == "twigs") then 
		
        inst.components.health:DoDelta(30) 
	inst.AnimState:PlayAnimation("eat")
        inst.SoundEmitter:PlaySound("dontstarve/characters/wolfgang/grow_medtolrg") 
        inst.components.follower:SetLeader(giver)
			inst.components.talker:Say("+30 HP")
    end
end

local function OnRefuseItem(inst, item)
    local playerprefab = GetPlayer()
    if playerprefab then
		inst.components.talker:Say("Back off!")
        inst.SoundEmitter:PlaySound("dontstarve/characters/wolfgang/shrink_lrgtomed") 		
    end
end


local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()	
	local whoisplayer = GetPlayer()	
	---------------------				
	inst.Transform:SetFourFaced(inst)
	shadow:SetSize( 1.5, .75 ) 
    MakeCharacterPhysics(inst, 75, .5)
	---------------------			
	anim:SetBank("wilson")
	anim:SetBuild("pumpkin_pet")
	---------------------	
    inst.AnimState:Hide("ARM_carry") 
    inst.AnimState:Show("ARM_normal") 
	---------------------	
	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier(1)
	inst.components.locomotor.triggerscreep = true      -- He will wake up spiders by stepping on the web.
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*1.1
	---------------------	
	inst:AddTag("pumpkin_guardian")
    inst:AddTag("character")
	inst:AddTag("scarytoprey")
    inst:AddTag("notraptrigger")  -- he won't trigger your traps.
	---------------------	
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetAttackPeriod(1.0)     -- 1.0 because we don't won't to stun lock enemies.
    inst.components.combat:SetDefaultDamage(30)     -- He's damage unarmed.
    inst.components.combat:SetRange(2.9, 60)  -- range of attack.
    inst.components.combat.panic_thresh = TUNING.BUNNYMAN_PANIC_THRESH
	---------------------	
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(500)
    inst.components.health.nofadeout = false  -- he will disappear after death.
    inst:ListenForEvent("death", ondeath)	
	inst.components.health.fire_damage_scale = 2 
	inst.components.health.canmurder = true -- you can kill him
	inst.components.health.canheal = false -- You can heal him only using emeralds!
	---------------------	
    inst:AddComponent("inspectable")  -- player can examine him.
	---------------------	
    inst:AddComponent("inventory")
	---------------------	
    inst:AddComponent("lootdropper")  -- he gives 10 emeralds as a loot after death
	inst.components.lootdropper:SetChanceLootTable('pumpkin_pet')
    inst:AddComponent("norecipelootdrop")	
	---------------------	
    local minimap = inst.entity:AddMiniMapEntity()  -- adding minimap icon option
    minimap:SetIcon( "pumpkin_pet.tex" )             -- map icon.
	---------------------	
    inst.items = items
    inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, GetWorld())
	---------------------	
    inst:AddComponent("follower")
    whoisplayer.components.leader:AddFollower(inst)	  -- he will follow player, when you create guardian.
    inst.components.follower.maxfollowtime = 99999999
    inst.components.follower:AddLoyaltyTime(9999999)	
	---------------------	
    inst:AddComponent("eater")
	---------------------	
	local brain = require"brains/pumpkin_petbrain"
	inst:SetBrain(brain)
	inst:SetStateGraph("SGpumpkin_pet")
	---------------------	
    inst:AddComponent("trader")                            -- he can take items.
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
	---------------------	
    inst:AddComponent("talker")                             -- he can speak
    inst.components.talker.fontsize = 35
    inst.components.talker.colour = Vector3(236/255, 136/255, 22/255) 
    inst.components.talker:StopIgnoringAll()
	---------------------	
    inst.Transform:SetScale(1.5, 1.5, 1.5) -- he's much bigger than Wilson.
	---------------------		
	
	return inst
end

return Prefab("common/pumpkin_pet", fn, assets, prefabs)