/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle;

import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.TimeInABottleItem;
import com.foxxite.timeinabottle.misc.Common;
import com.foxxite.timeinabottle.misc.Config;
import com.foxxite.timeinabottle.misc.Language;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CommandClass
implements CommandExecutor {
    Language language;
    Plugin plugin;
    Config config;

    public CommandClass(TimeInABottle plugin) {
        this.language = plugin.getLanguage();
        this.config = plugin.getPluginConfig();
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("tiab")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("timeinabottle.tiab")) {
                    if (args.length < 1) {
                        this.sendHelpMessage((CommandSender)player);
                        return true;
                    }
                    switch (args[0]) {
                        case "getBottle": 
                        case "getbottle": {
                            if (player.hasPermission("timeinabottle.tiab.getbottle")) {
                                this.giveTimeBottle(player);
                                return true;
                            }
                            this.sendNoPermissionMessage(player);
                            break;
                        }
                        case "giveBottle": 
                        case "givebottle": {
                            if (player.hasPermission("timeinabottle.tiab.givebottle")) {
                                if (args.length == 2 && !args[1].isEmpty()) {
                                    Player givePlayer = Bukkit.getPlayer((String)args[1]);
                                    if (givePlayer != null) {
                                        HashMap<String, String> placeholder = new HashMap<String, String>();
                                        placeholder.put("{target}", givePlayer.getName());
                                        player.sendMessage(this.language.getMessage("give-bottle", player, placeholder));
                                        this.giveTimeBottle(givePlayer);
                                    } else {
                                        HashMap<String, String> placeholder = new HashMap<String, String>();
                                        placeholder.put("{target}", args[1]);
                                        player.sendMessage(this.language.getMessage("player-not-found", player, placeholder));
                                    }
                                    return true;
                                }
                                this.giveTimeBottle(player);
                                break;
                            }
                            this.sendNoPermissionMessage(player);
                            break;
                        }
                        case "addTime": 
                        case "addtime": {
                            if (player.hasPermission("timeinabottle.tiab.addtime")) {
                                ItemStack checkItem = player.getInventory().getItemInMainHand();
                                TimeInABottleItem timeInABottleItem = new TimeInABottleItem(this.plugin, this.language);
                                if (checkItem != null && checkItem.getType() != Material.AIR && checkItem.getItemMeta().getDisplayName().equals(timeInABottleItem.bottleName)) {
                                    if (!args[1].isEmpty()) {
                                        int timeToAdd = 0;
                                        try {
                                            timeToAdd = Integer.parseInt(args[1]);
                                            this.updateBottleTime(checkItem, timeToAdd);
                                            int hours = timeToAdd / 3600;
                                            int minutes = timeToAdd % 3600 / 60;
                                            int seconds = timeToAdd % 60;
                                            String timeFormat = this.language.constructTimeFormat(hours, minutes, seconds);
                                            HashMap<String, String> customPlaceholder = new HashMap<String, String>();
                                            customPlaceholder.put("{hours}", Integer.toString(hours));
                                            customPlaceholder.put("{minutes}", Integer.toString(minutes));
                                            customPlaceholder.put("{seconds}", Integer.toString(seconds));
                                            customPlaceholder.put("{timeFormat}", timeFormat);
                                            customPlaceholder.put("{timeAdded}", Integer.toString(timeToAdd));
                                            player.sendMessage(this.language.getMessage("time-added", player, customPlaceholder));
                                        }
                                        catch (NumberFormatException ex) {
                                            player.sendMessage(this.language.getMessage("time-invalid", player));
                                        }
                                    } else {
                                        player.sendMessage(this.language.getMessage("time-empty", player));
                                    }
                                } else {
                                    player.sendMessage(this.language.getMessage("no-bottle", player));
                                }
                                return true;
                            }
                            this.sendNoPermissionMessage(player);
                            break;
                        }
                        case "reload": {
                            String message = "";
                            message = this.language.reloadConfig() != false && this.config.reloadConfig() ? this.language.getMessage("reload") : this.language.getMessage("prefix") + Common.colorize("&cAn internal error occurred while reloading the plugin. See the console for more information.");
                            sender.sendMessage(message);
                            break;
                        }
                        default: {
                            this.sendHelpMessage((CommandSender)player);
                            break;
                        }
                    }
                } else {
                    this.sendNoPermissionMessage(player);
                }
            } else {
                if (args.length < 1) {
                    this.sendHelpMessage(sender);
                    return true;
                }
                switch (args[0]) {
                    case "giveBottle": 
                    case "givebottle": {
                        if (args.length > 1 && !args[1].isEmpty()) {
                            Player givePlayer = Bukkit.getPlayer((String)args[1]);
                            if (givePlayer != null) {
                                HashMap<String, String> placeholder = new HashMap<String, String>();
                                placeholder.put("{target}", givePlayer.getName());
                                sender.sendMessage(this.language.getMessage("give-bottle", placeholder));
                                this.giveTimeBottle(givePlayer);
                            } else {
                                HashMap<String, String> placeholder = new HashMap<String, String>();
                                placeholder.put("{target}", args[1]);
                                sender.sendMessage(this.language.getMessage("player-not-found", placeholder));
                            }
                            return true;
                        }
                        sender.sendMessage(this.language.getMessage("player-missing"));
                        break;
                    }
                    case "reload": {
                        String message = "";
                        message = this.language.reloadConfig() != false && this.config.reloadConfig() ? this.language.getMessage("reload") : this.language.getMessage("prefix") + Common.colorize("&cAn internal error occurred while reloading the plugin. See the console for more information.");
                        sender.sendMessage(message);
                        break;
                    }
                    default: {
                        sender.sendMessage(this.language.getMessage("not-player"));
                    }
                }
            }
        }
        return true;
    }

    void sendHelpMessage(CommandSender sender) {
        if (sender instanceof Player) {
            for (String message : this.language.getListMessage("help-message", (Player)sender)) {
                sender.sendMessage(message);
            }
            return;
        }
        for (String message : this.language.getListMessage("help-message")) {
            sender.sendMessage(message);
        }
    }

    void sendNoPermissionMessage(Player player) {
        player.sendMessage(this.language.getMessage("no-permission", player));
    }

    void updateBottleTime(ItemStack bottleItem, int timeToAdd) {
        ItemMeta bottleMeta = bottleItem.getItemMeta();
        List newLore = bottleMeta.getLore();
        String stringSeconds = ChatColor.stripColor((String)((String)bottleMeta.getLore().get(2)));
        if (stringSeconds.isEmpty()) {
            stringSeconds = "" + timeToAdd;
        }
        int storedSeconds = Integer.parseInt(stringSeconds);
        newLore.set(2, Common.colorize("&0" + (storedSeconds += timeToAdd)));
        bottleMeta.setLore(newLore);
        bottleItem.setItemMeta(bottleMeta);
    }

    void giveTimeBottle(Player player) {
        TimeInABottleItem timeInABottleItem = new TimeInABottleItem(this.plugin, this.language);
        ItemStack bottleItem = timeInABottleItem.bottleItem;
        timeInABottleItem.makeItemUnique();
        if (player.getInventory().firstEmpty() != -1) {
            player.getInventory().addItem(new ItemStack[]{bottleItem});
            player.sendMessage(this.language.getMessage("received-bottle", player));
        } else {
            player.sendMessage(this.language.getMessage("inventory-full", player));
        }
    }
}

