/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle;

import com.foxxite.timeinabottle.misc.Common;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Block;

public class GrowTree {
    Block block;
    TreeType treeType;

    public GrowTree(Block block, TreeType treeType) {
        this.block = block;
        this.treeType = treeType;
    }

    public void SpawnMultiTree() {
        switch (this.treeType) {
            case REDWOOD: {
                Location baseSapling = this.findBaseSapling(Material.SPRUCE_SAPLING);
                if (baseSapling != null) {
                    this.removeBaseSaplings(baseSapling);
                    World world = baseSapling.getWorld();
                    world.generateTree(baseSapling, TreeType.MEGA_REDWOOD);
                    break;
                }
                World world = this.block.getWorld();
                if (Common.getRandomNumber(1.0, 2.0) == 1) {
                    world.generateTree(this.block.getLocation(), TreeType.REDWOOD);
                    break;
                }
                world.generateTree(this.block.getLocation(), TreeType.TALL_REDWOOD);
                break;
            }
            case JUNGLE: {
                Location baseSapling = this.findBaseSapling(Material.JUNGLE_SAPLING);
                if (baseSapling != null) {
                    this.removeBaseSaplings(baseSapling);
                    World world = baseSapling.getWorld();
                    if (Common.getRandomNumber(1.0, 2.0) == 1) {
                        world.generateTree(this.block.getLocation(), TreeType.JUNGLE);
                        break;
                    }
                    world.generateTree(this.block.getLocation(), TreeType.COCOA_TREE);
                    break;
                }
                World world = this.block.getWorld();
                world.generateTree(this.block.getLocation(), TreeType.SMALL_JUNGLE);
                break;
            }
            case DARK_OAK: {
                Location baseSapling = this.findBaseSapling(Material.DARK_OAK_SAPLING);
                if (baseSapling == null) break;
                this.removeBaseSaplings(baseSapling);
                World world = baseSapling.getWorld();
                world.generateTree(this.block.getLocation(), TreeType.DARK_OAK);
            }
        }
    }

    void removeBaseSaplings(Location baseSapling) {
        Location removeLocation = baseSapling;
        removeLocation.getBlock().setType(Material.AIR);
        removeLocation.setX(removeLocation.getX() + 1.0);
        removeLocation.getBlock().setType(Material.AIR);
        removeLocation.setZ(removeLocation.getZ() + 1.0);
        removeLocation.getBlock().setType(Material.AIR);
        removeLocation.setX(removeLocation.getX() - 1.0);
        removeLocation.getBlock().setType(Material.AIR);
    }

    Location findBaseSapling(Material material) {
        ArrayList<Boolean> neighborSaplings = this.searchForSameSaplings(this.block.getLocation(), material);
        if (neighborSaplings.get(0).booleanValue() && neighborSaplings.get(1).booleanValue()) {
            Location newSearchLocation = this.block.getLocation();
            newSearchLocation.setX(newSearchLocation.getX() - 1.0);
            newSearchLocation.setZ(newSearchLocation.getZ() - 1.0);
            if (newSearchLocation.getBlock().getType() == material) {
                return newSearchLocation;
            }
        } else if (neighborSaplings.get(1).booleanValue() && neighborSaplings.get(2).booleanValue()) {
            Location newSearchLocation = this.block.getLocation();
            newSearchLocation.setX(newSearchLocation.getX() - 1.0);
            newSearchLocation.setZ(newSearchLocation.getZ() + 1.0);
            if (newSearchLocation.getBlock().getType() == material) {
                Location returnLoc = this.block.getLocation();
                newSearchLocation.setX(newSearchLocation.getX() - 1.0);
                return returnLoc;
            }
        } else if (neighborSaplings.get(2).booleanValue() && neighborSaplings.get(3).booleanValue()) {
            Location newSearchLocation = this.block.getLocation();
            newSearchLocation.setX(newSearchLocation.getX() + 1.0);
            newSearchLocation.setZ(newSearchLocation.getZ() + 1.0);
            if (newSearchLocation.getBlock().getType() == material) {
                return this.block.getLocation();
            }
        } else if (neighborSaplings.get(0).booleanValue() && neighborSaplings.get(3).booleanValue()) {
            Location newSearchLocation = this.block.getLocation();
            newSearchLocation.setX(newSearchLocation.getX() + 1.0);
            newSearchLocation.setZ(newSearchLocation.getZ() - 1.0);
            if (newSearchLocation.getBlock().getType() == material) {
                Location returnLoc = this.block.getLocation();
                newSearchLocation.setZ(newSearchLocation.getZ() - 1.0);
                return returnLoc;
            }
        }
        return null;
    }

    ArrayList<Boolean> searchForSameSaplings(Location baseSearchLocation, Material material) {
        boolean North = false;
        boolean West = false;
        boolean South = false;
        boolean East = false;
        Location searchLoc = baseSearchLocation;
        searchLoc.setZ(searchLoc.getZ() - 1.0);
        North = searchLoc.getBlock().getType() == material;
        searchLoc.setZ(searchLoc.getZ() + 1.0);
        searchLoc.setX(searchLoc.getX() - 1.0);
        West = searchLoc.getBlock().getType() == material;
        searchLoc.setX(searchLoc.getX() + 1.0);
        searchLoc.setZ(searchLoc.getZ() + 1.0);
        South = searchLoc.getBlock().getType() == material;
        searchLoc.setZ(searchLoc.getZ() - 1.0);
        searchLoc.setX(searchLoc.getX() + 1.0);
        East = searchLoc.getBlock().getType() == material;
        ArrayList<Boolean> output = new ArrayList<Boolean>();
        output.add(North);
        output.add(West);
        output.add(South);
        output.add(East);
        return output;
    }
}

