/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle;

import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.misc.Common;
import com.foxxite.timeinabottle.misc.Config;
import com.foxxite.timeinabottle.misc.Language;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TimeInABottleItem {
    private final Language language;
    private final Config config;
    private final Plugin plugin;
    public String bottleName = Common.colorize("&eTime In A Bottle");
    public Material bottleMaterial = Material.EXPERIENCE_BOTTLE;
    public ItemStack bottleItem = new ItemStack(this.bottleMaterial);

    public TimeInABottleItem(Plugin plugin, Language language) {
        ArrayList<String> rawLore;
        this.plugin = plugin;
        this.language = language;
        this.config = TimeInABottle.pluginConfig;
        ItemMeta itemMeta = this.bottleItem.getItemMeta();
        itemMeta.setDisplayName(this.bottleName);
        String timeFormat = language.constructTimeFormat(0, 0, 0);
        HashMap<String, String> customPlaceholder = new HashMap<String, String>();
        customPlaceholder.put("{hours}", "0");
        customPlaceholder.put("{minutes}", "0");
        customPlaceholder.put("{seconds}", "0");
        customPlaceholder.put("{timeFormat}", timeFormat);
        ArrayList<String> lore = rawLore = language.getListMessage("bottle-lore", customPlaceholder);
        lore.set(2, "");
        lore.set(5, Common.colorize("&0"));
        itemMeta.setLore(lore);
        this.bottleItem.setItemMeta(itemMeta);
    }

    public void makeItemUnique() {
        ItemStack bottleItem = this.bottleItem;
        ItemMeta bottleItemMeta = bottleItem.getItemMeta();
        List newLore = bottleItemMeta.getLore();
        newLore.set(5, Common.colorize("&0" + UUID.randomUUID()));
        bottleItemMeta.setLore(newLore);
        bottleItem.setItemMeta(bottleItemMeta);
    }

    public void registerBottleRecipe() {
        NamespacedKey key = new NamespacedKey(this.plugin, "time_in_a_bottle");
        ShapedRecipe bottleRecipe = new ShapedRecipe(key, this.bottleItem);
        List recipePattern = this.config.getConfig().getStringList("recipe.pattern");
        bottleRecipe.shape(new String[]{(String)recipePattern.get(0), (String)recipePattern.get(1), (String)recipePattern.get(2)});
        ConfigurationSection materials = this.config.getConfig().getConfigurationSection("recipe.materials");
        Set materialKeys = materials.getKeys(false);
        for (String materialKey : materialKeys) {
            Material material = Material.getMaterial((String)this.config.getConfig().getString("recipe.materials." + materialKey));
            bottleRecipe.setIngredient(materialKey.toCharArray()[0], material);
        }
        Bukkit.addRecipe((Recipe)bottleRecipe);
    }
}

