/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle;

import com.foxxite.timeinabottle.GrowTree;
import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.misc.Common;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlastFurnace;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Campfire;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Furnace;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TurtleEgg;

public class TimedBlock {
    public int state;
    public Block block;
    public Material blockMaterial;
    public long startTime;

    public TimedBlock(int state, Block block) {
        this.state = state;
        this.block = block;
        this.blockMaterial = block.getType();
        this.startTime = System.currentTimeMillis() / 1000L;
    }

    public void UpdateBlock() {
        BlockState blockState = this.block.getState();
        Material checkMaterial = this.block.getType();
        if (!TimeInABottle.pluginConfig.getConfig().getStringList("enabled-blocks").contains(checkMaterial.toString())) {
            checkMaterial = Material.BEDROCK;
        }
        switch (checkMaterial) {
            case FURNACE: {
                Furnace furnace = (Furnace)blockState;
                if (furnace.getCookTime() >= 200) break;
                furnace.setCookTime((short)(furnace.getCookTime() + 1));
                furnace.setBurnTime((short)(furnace.getBurnTime() - 1));
                furnace.update();
                break;
            }
            case BLAST_FURNACE: {
                BlastFurnace blastFurnace = (BlastFurnace)blockState;
                if (blastFurnace.getCookTime() >= 200) break;
                blastFurnace.setCookTime((short)(blastFurnace.getCookTime() + 1));
                blastFurnace.setBurnTime((short)(blastFurnace.getBurnTime() - 1));
                blastFurnace.update();
                break;
            }
            case SMOKER: {
                Smoker smoker = (Smoker)blockState;
                if (smoker.getCookTime() >= 200) break;
                smoker.setCookTime((short)(smoker.getCookTime() + 1));
                smoker.setBurnTime((short)(smoker.getBurnTime() - 1));
                smoker.update();
                break;
            }
            case WHEAT: 
            case CARROTS: 
            case POTATOES: 
            case BEETROOTS: 
            case SUGAR_CANE: 
            case CACTUS: 
            case KELP: 
            case CHORUS_FLOWER: 
            case SWEET_BERRY_BUSH: 
            case BAMBOO: 
            case COCOA: 
            case NETHER_WART: {
                Ageable ageable = (Ageable)this.block.getBlockData();
                if (ageable.getAge() >= ageable.getMaximumAge() || Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                ageable.setAge(ageable.getAge() + 1);
                this.block.setBlockData((BlockData)ageable);
                break;
            }
            case OAK_SAPLING: {
                if (Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                this.block.setType(Material.AIR);
                World world = this.block.getWorld();
                if (Common.getRandomNumber(1.0, 2.0) == 1) {
                    world.generateTree(this.block.getLocation(), TreeType.TREE);
                    break;
                }
                world.generateTree(this.block.getLocation(), TreeType.BIG_TREE);
                break;
            }
            case BIRCH_SAPLING: {
                if (Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                this.block.setType(Material.AIR);
                World world = this.block.getWorld();
                if (Common.getRandomNumber(1.0, 2.0) == 1) {
                    world.generateTree(this.block.getLocation(), TreeType.BIRCH);
                    break;
                }
                world.generateTree(this.block.getLocation(), TreeType.TALL_BIRCH);
                break;
            }
            case ACACIA_SAPLING: {
                if (Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                this.block.setType(Material.AIR);
                World world = this.block.getWorld();
                world.generateTree(this.block.getLocation(), TreeType.ACACIA);
                break;
            }
            case SPRUCE_SAPLING: {
                if (Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                this.block.setType(Material.AIR);
                GrowTree growTree = new GrowTree(this.block, TreeType.REDWOOD);
                growTree.SpawnMultiTree();
                break;
            }
            case DARK_OAK_SAPLING: {
                if (Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                GrowTree growTree = new GrowTree(this.block, TreeType.DARK_OAK);
                growTree.SpawnMultiTree();
                break;
            }
            case JUNGLE_SAPLING: {
                if (Common.getRandomNumber(1.0, 100 * (this.state + 1)) != 100 * (this.state + 1)) break;
                this.block.setType(Material.AIR);
                GrowTree growTree = new GrowTree(this.block, TreeType.JUNGLE);
                growTree.SpawnMultiTree();
                break;
            }
            case SPAWNER: {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                if (spawner.getDelay() <= 0) break;
                spawner.setDelay((short)spawner.getDelay() - 5);
                spawner.update();
                break;
            }
            case TURTLE_EGG: {
                TurtleEgg turtleEgg;
                if (Common.getRandomNumber(1.0, 300 * (this.state + 1)) != 300 * (this.state + 1) || (turtleEgg = (TurtleEgg)this.block.getBlockData()).getHatch() >= turtleEgg.getMaximumHatch()) break;
                turtleEgg.setHatch(turtleEgg.getHatch() + 1);
                this.block.setBlockData((BlockData)turtleEgg);
                break;
            }
            case CAMPFIRE: {
                Campfire campfire = (Campfire)blockState;
                for (int i = 0; i < 4; ++i) {
                    if (campfire.getCookTime(i) >= 600) continue;
                    campfire.setCookTime(i, (int)((short)(campfire.getCookTime(i) + 1)));
                    campfire.update();
                }
                break;
            }
            case BREWING_STAND: {
                BrewingStand brewingStand = (BrewingStand)blockState;
                if (brewingStand.getBrewingTime() <= 1) break;
                brewingStand.setBrewingTime((int)((short)(brewingStand.getBrewingTime() - 1)));
                brewingStand.update();
                break;
            }
            default: {
                if (!TimeInABottle.pluginConfig.getConfig().getBoolean("bottle.unknown-blocks")) break;
                Location particleLocation = this.block.getLocation();
                particleLocation.setX(particleLocation.getX() + 0.5);
                particleLocation.setY(particleLocation.getY() + 1.0);
                particleLocation.setZ(particleLocation.getZ() + 0.5);
                particleLocation.getWorld().spawnParticle(Particle.REDSTONE, particleLocation, 0, 0.001, 1.0, 0.0, 1.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                blockState.update(true, true);
            }
        }
    }

    public void ResetBlock() {
        BlockState blockState = this.block.getState();
        blockState.update(true, true);
    }
}

