/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.events;

import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.TimeInABottleItem;
import com.foxxite.timeinabottle.misc.Config;
import com.foxxite.timeinabottle.misc.Language;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerCraftListener
implements Listener {
    private final Plugin plugin;
    private final TimeInABottleItem timeInABottleItem;
    private final Language language;
    private final Config config;

    public PlayerCraftListener(TimeInABottle plugin) {
        this.plugin = plugin;
        this.config = plugin.getPluginConfig();
        this.language = plugin.getLanguage();
        this.timeInABottleItem = new TimeInABottleItem((Plugin)plugin, this.language);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraftClick(InventoryClickEvent event) {
        ItemMeta resultItemMeta;
        ItemStack resultItem;
        if (event.getSlotType() == InventoryType.SlotType.RESULT && (resultItem = event.getCurrentItem()) != null && resultItem.getType() != Material.AIR && (resultItemMeta = resultItem.getItemMeta()).getDisplayName().equals(this.timeInABottleItem.bottleName)) {
            if (event.isShiftClick()) {
                event.setCancelled(true);
                Player player = (Player)event.getWhoClicked();
                player.sendMessage(this.language.getMessage("no-multi-craft", player));
                Sound error = Sound.valueOf((String)TimeInABottle.pluginConfig.getConfig().getString("sounds.error"));
                player.playSound(player.getLocation(), error, SoundCategory.MASTER, 1.0f, 1.0f);
                return;
            }
            event.setResult(Event.Result.ALLOW);
            ItemStack bottleItem = this.timeInABottleItem.bottleItem;
            this.timeInABottleItem.makeItemUnique();
            event.setCurrentItem(bottleItem);
        }
    }
}

