/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.events;

import com.foxxite.timeinabottle.TimeInABottle;
import com.foxxite.timeinabottle.TimeInABottleItem;
import com.foxxite.timeinabottle.TimedBlock;
import com.foxxite.timeinabottle.misc.Common;
import com.foxxite.timeinabottle.misc.Language;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerInteractListener
implements Listener {
    private final Plugin plugin;
    private final TimeInABottleItem timeInABottleItem;
    private final Language language;

    public PlayerInteractListener(TimeInABottle plugin) {
        this.plugin = plugin;
        this.language = plugin.getLanguage();
        this.timeInABottleItem = new TimeInABottleItem((Plugin)plugin, this.language);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() != null && event.getItem().getType() != Material.AIR && event.getItem().getItemMeta().getDisplayName().equals(this.timeInABottleItem.bottleName) && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            if (!event.getPlayer().isSneaking() && event.getClickedBlock() != null && (event.getClickedBlock().getState() instanceof InventoryHolder || event.getClickedBlock().getType() == Material.CRAFTING_TABLE)) {
                return;
            }
            event.setCancelled(true);
            if (event.getPlayer().isSneaking() && event.getClickedBlock() != null && event.getClickedBlock().getType() != Material.AIR) {
                Block block = event.getClickedBlock();
                Player player = event.getPlayer();
                ItemStack bottleItem = event.getItem();
                boolean playSound = false;
                int currTime = Integer.parseInt(ChatColor.stripColor((String)((String)bottleItem.getItemMeta().getLore().get(2))));
                if (player.hasPermission("timeinabottle.timebypass") || currTime > TimeInABottle.pluginConfig.getConfig().getInt("bottle.level-cost")) {
                    if (TimeInABottle.pluginConfig.getConfig().getStringList("enabled-blocks").contains(block.getType().toString()) || TimeInABottle.pluginConfig.getConfig().getBoolean("bottle.unknown-blocks")) {
                        if (TimeInABottle.timedBlocks.containsKey(block)) {
                            if (TimeInABottle.timedBlocks.get((Object)block).state < 4) {
                                int newState = ++TimeInABottle.timedBlocks.get((Object)block).state;
                                TimeInABottle.timedBlocks.remove(block);
                                TimedBlock timedBlock = new TimedBlock(newState, block);
                                TimeInABottle.timedBlocks.put(block, timedBlock);
                                playSound = true;
                            }
                        } else {
                            TimedBlock timedBlock = new TimedBlock(0, block);
                            TimeInABottle.timedBlocks.put(block, timedBlock);
                            playSound = true;
                        }
                    }
                    if (playSound) {
                        float pitch = 1.0f;
                        switch (TimeInABottle.timedBlocks.get((Object)block).state) {
                            case 1: 
                            case 4: {
                                pitch = 0.890899f;
                                break;
                            }
                            case 2: {
                                pitch = 1.059463f;
                                break;
                            }
                            case 3: {
                                pitch = 0.943874f;
                                break;
                            }
                            default: {
                                pitch = 0.793701f;
                            }
                        }
                        Sound levelUp = Sound.valueOf((String)TimeInABottle.pluginConfig.getConfig().getString("sounds.level-up"));
                        Sound levelUpUnder = Sound.valueOf((String)TimeInABottle.pluginConfig.getConfig().getString("sounds.level-up-under"));
                        player.getWorld().playSound(player.getLocation(), levelUp, SoundCategory.BLOCKS, 1.0f, pitch);
                        player.getWorld().playSound(player.getLocation(), levelUpUnder, SoundCategory.BLOCKS, 1.0f, pitch);
                        ItemMeta bottleItemMeta = bottleItem.getItemMeta();
                        List lore = bottleItemMeta.getLore();
                        lore.set(2, Common.colorize("&0" + (currTime - TimeInABottle.pluginConfig.getConfig().getInt("bottle.level-cost"))));
                        bottleItemMeta.setLore(lore);
                        bottleItem.setItemMeta(bottleItemMeta);
                    }
                } else {
                    Sound error = Sound.valueOf((String)TimeInABottle.pluginConfig.getConfig().getString("sounds.error"));
                    player.playSound(player.getLocation(), error, SoundCategory.MASTER, 1.0f, 1.0f);
                    player.sendMessage(this.language.getMessage("not-enough-time", player));
                }
            }
        }
    }
}

