/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.misc;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class Common {
    public static void tell(CommandSender sender, String message) {
        sender.sendMessage(Common.colorize(message));
    }

    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void setRepairCost(ItemStack itemStack, int repairCost) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Repairable) {
            Repairable repairable = (Repairable)itemMeta;
            repairable.setRepairCost(repairCost);
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static int getRepairCost(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return -1;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Repairable) {
            Repairable repairable = (Repairable)itemMeta;
            return repairable.getRepairCost();
        }
        return -1;
    }

    public static Player getPlayerByUuid(UUID uuid) {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!p.getUniqueId().equals(uuid)) continue;
            return p;
        }
        return null;
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static int getRandomNumber(double min, double max) {
        int x = (int)Math.round(Math.random() * (max - min + 1.0) + min);
        return x;
    }
}

