/*
 * Decompiled with CFR 0.152.
 */
package com.foxxite.timeinabottle.misc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    private final Plugin plugin;
    private File configFile;
    private FileConfiguration config;

    public Config(Plugin plugin) {
        this.plugin = plugin;
        try {
            this.createConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean reloadConfig() {
        try {
            this.createConfig();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    private void createConfig() throws IOException {
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.plugin.saveResource("config.yml", false);
        } else {
            try {
                YamlConfiguration tempConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
                InputStream internalConfigFile = this.plugin.getResource("config.yml");
                InputStreamReader internalConfigFileReader = new InputStreamReader(internalConfigFile);
                YamlConfiguration internalConfig = YamlConfiguration.loadConfiguration((Reader)internalConfigFileReader);
                if (tempConfig.getInt("file-version") != internalConfig.getInt("file-version")) {
                    File oldConfigFile = new File(this.plugin.getDataFolder(), "config_old.yml");
                    this.configFile.getParentFile().mkdirs();
                    tempConfig.save(oldConfigFile);
                    this.configFile.getParentFile().mkdirs();
                    this.plugin.saveResource("config.yml", true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

